exps=output/cot_vqa_mmrlhf13k_img1536_bem_correct
log_dir=${exps}/output.log
mkdir -p ${exps}

export DEBUG_MODE=true
export LOG_PATH=${exps}/debug.log

torchrun --nproc_per_node=8 \
    --master_port=12346 \
    grpo_cot_vqa.py \
    --deepspeed /mnt/bn/pistis/liutao.0220/VLM-R1/src/open-r1-multimodal/local_scripts/zero3.json \
    --output_dir ${exps} \
    --model_name_or_path /mnt/bn/pistis/liutao.0220/MODEL/Qwen2.5-VL-3B-Instruct \
    --dataset_name /mnt/bn/pistis/liutao.0220/VLM-R1/src/open-r1-multimodal/data_config/mmrlhf13k.yaml \
    --image_root /inspurfs/group/hexm/GUI/Mind2Web/images/ \
    --max_prompt_length 1024 \
    --num_generations 4 \
    --per_device_train_batch_size 4 \
    --gradient_accumulation_steps 1 \
    --logging_steps 1 \
    --bf16 \
    --torch_dtype bfloat16 \
    --reward_funcs correctness_bem_score format \
    --data_seed 42 \
    --report_to tensorboard \
    --gradient_checkpointing true \
    --attn_implementation flash_attention_2 \
    --num_train_epochs 1 \
    --run_name ${exps} \
    --save_steps 200 \
    --max_pixels 2359296 \
    --save_only_model true \
    2>&1 | tee -a ${log_dir}